/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class HttpServlet
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    private static final Set<String> SENSITIVE_HTTP_HEADERS = new HashSet<String>();
    private final transient Object cachedAllowHeaderValueLock = new Object();
    private volatile String cachedAllowHeaderValue = null;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String msg = lStrings.getString("http.method_get_not_supported");
        this.sendMethodNotAllowed(req, resp, msg);
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (DispatcherType.INCLUDE.equals((Object)req.getDispatcherType())) {
            this.doGet(req, resp);
        } else {
            NoBodyResponse response = new NoBodyResponse(resp);
            this.doGet(req, response);
            if (req.isAsyncStarted()) {
                req.getAsyncContext().addListener(new NoBodyAsyncContextListener(response));
            } else {
                response.setContentLength();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String msg = lStrings.getString("http.method_post_not_supported");
        this.sendMethodNotAllowed(req, resp, msg);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String msg = lStrings.getString("http.method_put_not_supported");
        this.sendMethodNotAllowed(req, resp, msg);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String msg = lStrings.getString("http.method_delete_not_supported");
        this.sendMethodNotAllowed(req, resp, msg);
    }

    private void sendMethodNotAllowed(HttpServletRequest req, HttpServletResponse resp, String msg) throws IOException {
        String protocol = req.getProtocol();
        if (protocol.length() == 0 || protocol.endsWith("0.9") || protocol.endsWith("1.0")) {
            resp.sendError(400, msg);
        } else {
            resp.sendError(405, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedAllowHeaderValue() {
        if (this.cachedAllowHeaderValue == null) {
            Object object = this.cachedAllowHeaderValueLock;
            synchronized (object) {
                if (this.cachedAllowHeaderValue == null) {
                    Method[] methods = HttpServlet.getAllDeclaredMethods(this.getClass());
                    boolean allowGet = false;
                    boolean allowHead = false;
                    boolean allowPost = false;
                    boolean allowPut = false;
                    boolean allowDelete = false;
                    block15: for (Method method : methods) {
                        switch (method.getName()) {
                            case "doGet": {
                                allowGet = true;
                                allowHead = true;
                                continue block15;
                            }
                            case "doPost": {
                                allowPost = true;
                                continue block15;
                            }
                            case "doPut": {
                                allowPut = true;
                                continue block15;
                            }
                            case "doDelete": {
                                allowDelete = true;
                                continue block15;
                            }
                        }
                    }
                    StringBuilder allow = new StringBuilder();
                    if (allowGet) {
                        allow.append(METHOD_GET);
                        allow.append(", ");
                    }
                    if (allowHead) {
                        allow.append(METHOD_HEAD);
                        allow.append(", ");
                    }
                    if (allowPost) {
                        allow.append(METHOD_POST);
                        allow.append(", ");
                    }
                    if (allowPut) {
                        allow.append(METHOD_PUT);
                        allow.append(", ");
                    }
                    if (allowDelete) {
                        allow.append(METHOD_DELETE);
                        allow.append(", ");
                    }
                    allow.append(METHOD_OPTIONS);
                    this.cachedAllowHeaderValue = allow.toString();
                }
            }
        }
        return this.cachedAllowHeaderValue;
    }

    private static Method[] getAllDeclaredMethods(Class<?> c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = HttpServlet.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String allow = this.getCachedAllowHeaderValue();
        if (TomcatHack.getAllowTrace(req)) {
            allow = allow.length() == 0 ? METHOD_TRACE : allow + ", " + METHOD_TRACE;
        }
        resp.setHeader("Allow", allow);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String CRLF = "\r\n";
        StringBuilder buffer = new StringBuilder("TRACE ").append(req.getRequestURI()).append(" ").append(req.getProtocol());
        Enumeration<String> reqHeaderNames = req.getHeaderNames();
        while (reqHeaderNames.hasMoreElements()) {
            String headerName = reqHeaderNames.nextElement();
            if (SENSITIVE_HTTP_HEADERS.contains(headerName.toLowerCase(Locale.ENGLISH))) continue;
            Enumeration<String> headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = headerValues.nextElement();
                buffer.append(CRLF).append(headerName).append(": ").append(headerValue);
            }
        }
        buffer.append(CRLF);
        int responseLength = buffer.length();
        resp.setContentType("message/http");
        resp.setContentLength(responseLength);
        ServletOutputStream out = resp.getOutputStream();
        out.print(buffer.toString());
        out.close();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals(METHOD_GET)) {
            long lastModified = this.getLastModified(req);
            if (lastModified == -1L) {
                this.doGet(req, resp);
            } else {
                long ifModifiedSince;
                try {
                    ifModifiedSince = req.getDateHeader(HEADER_IFMODSINCE);
                }
                catch (IllegalArgumentException iae) {
                    ifModifiedSince = -1L;
                }
                if (ifModifiedSince < lastModified / 1000L * 1000L) {
                    this.maybeSetLastModified(resp, lastModified);
                    this.doGet(req, resp);
                } else {
                    resp.setStatus(304);
                }
            }
        } else if (method.equals(METHOD_HEAD)) {
            long lastModified = this.getLastModified(req);
            this.maybeSetLastModified(resp, lastModified);
            this.doHead(req, resp);
        } else if (method.equals(METHOD_POST)) {
            this.doPost(req, resp);
        } else if (method.equals(METHOD_PUT)) {
            this.doPut(req, resp);
        } else if (method.equals(METHOD_DELETE)) {
            this.doDelete(req, resp);
        } else if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(req, resp);
        } else if (method.equals(METHOD_TRACE)) {
            this.doTrace(req, resp);
        } else {
            String errMsg = lStrings.getString("http.method_not_implemented");
            Object[] errArgs = new Object[]{method};
            errMsg = MessageFormat.format(errMsg, errArgs);
            resp.sendError(501, errMsg);
        }
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader(HEADER_LASTMOD, lastModified);
        }
    }

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException(lStrings.getString("http.non_http"));
        }
        this.service(request, response);
    }

    static {
        SENSITIVE_HTTP_HEADERS.add("cookie");
        SENSITIVE_HTTP_HEADERS.add("authorization");
    }

    private static class NoBodyAsyncContextListener
    implements AsyncListener {
        private final NoBodyResponse noBodyResponse;

        public NoBodyAsyncContextListener(NoBodyResponse noBodyResponse) {
            this.noBodyResponse = noBodyResponse;
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            this.noBodyResponse.setContentLength();
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }

    private static class NoBodyPrintWriter
    extends PrintWriter {
        private final NoBodyOutputStream out;
        private final String encoding;
        private PrintWriter pw;

        public NoBodyPrintWriter(NoBodyOutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out);
            this.out = out;
            this.encoding = encoding;
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, encoding);
            this.pw = new PrintWriter(osw);
        }

        private void resetBuffer() {
            this.out.resetBuffer();
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)this.out, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.pw = new PrintWriter(osw);
        }

        @Override
        public void flush() {
            this.pw.flush();
        }

        @Override
        public void close() {
            this.pw.close();
        }

        @Override
        public boolean checkError() {
            return this.pw.checkError();
        }

        @Override
        public void write(int c) {
            this.pw.write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            this.pw.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            this.pw.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            this.pw.write(s, off, len);
        }

        @Override
        public void write(String s) {
            this.pw.write(s);
        }

        @Override
        public void print(boolean b) {
            this.pw.print(b);
        }

        @Override
        public void print(char c) {
            this.pw.print(c);
        }

        @Override
        public void print(int i) {
            this.pw.print(i);
        }

        @Override
        public void print(long l) {
            this.pw.print(l);
        }

        @Override
        public void print(float f) {
            this.pw.print(f);
        }

        @Override
        public void print(double d) {
            this.pw.print(d);
        }

        @Override
        public void print(char[] s) {
            this.pw.print(s);
        }

        @Override
        public void print(String s) {
            this.pw.print(s);
        }

        @Override
        public void print(Object obj) {
            this.pw.print(obj);
        }

        @Override
        public void println() {
            this.pw.println();
        }

        @Override
        public void println(boolean x) {
            this.pw.println(x);
        }

        @Override
        public void println(char x) {
            this.pw.println(x);
        }

        @Override
        public void println(int x) {
            this.pw.println(x);
        }

        @Override
        public void println(long x) {
            this.pw.println(x);
        }

        @Override
        public void println(float x) {
            this.pw.println(x);
        }

        @Override
        public void println(double x) {
            this.pw.println(x);
        }

        @Override
        public void println(char[] x) {
            this.pw.println(x);
        }

        @Override
        public void println(String x) {
            this.pw.println(x);
        }

        @Override
        public void println(Object x) {
            this.pw.println(x);
        }
    }

    private static class NoBodyOutputStream
    extends ServletOutputStream {
        private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
        private static final ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
        private final NoBodyResponse response;
        private boolean flushed = false;
        private long writtenByteCount = 0L;

        private NoBodyOutputStream(NoBodyResponse response) {
            this.response = response;
        }

        private long getWrittenByteCount() {
            return this.writtenByteCount;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.writtenByteCount;
            this.checkCommit();
        }

        @Override
        public void write(byte[] buf, int offset, int len) throws IOException {
            if (buf == null) {
                throw new NullPointerException(lStrings.getString("err.io.nullArray"));
            }
            if (offset < 0 || len < 0 || offset + len > buf.length) {
                String msg = lStrings.getString("err.io.indexOutOfBounds");
                Object[] msgArgs = new Object[]{offset, len, buf.length};
                msg = MessageFormat.format(msg, msgArgs);
                throw new IndexOutOfBoundsException(msg);
            }
            this.writtenByteCount += (long)len;
            this.checkCommit();
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener listener) {
            this.response.originalOutputStream.setWriteListener(listener);
        }

        private void checkCommit() throws IOException {
            if (!this.flushed && this.writtenByteCount > (long)this.response.getBufferSize()) {
                this.response.flushBuffer();
                this.flushed = true;
            }
        }

        private void resetBuffer() {
            if (this.flushed) {
                throw new IllegalStateException(lStrings.getString("err.state.commit"));
            }
            this.writtenByteCount = 0L;
        }
    }

    private static class NoBodyResponse
    extends HttpServletResponseWrapper {
        private final NoBodyOutputStream noBodyOutputStream = new NoBodyOutputStream(this);
        private ServletOutputStream originalOutputStream;
        private NoBodyPrintWriter noBodyWriter;
        private boolean didSetContentLength;

        private NoBodyResponse(HttpServletResponse r) {
            super(r);
        }

        private void setContentLength() {
            if (!this.didSetContentLength) {
                if (this.noBodyWriter != null) {
                    this.noBodyWriter.flush();
                }
                super.setContentLengthLong(this.noBodyOutputStream.getWrittenByteCount());
            }
        }

        @Override
        public void setContentLength(int len) {
            super.setContentLength(len);
            this.didSetContentLength = true;
        }

        @Override
        public void setContentLengthLong(long len) {
            super.setContentLengthLong(len);
            this.didSetContentLength = true;
        }

        @Override
        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            this.checkHeader(name);
        }

        @Override
        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            this.checkHeader(name);
        }

        @Override
        public void setIntHeader(String name, int value) {
            super.setIntHeader(name, value);
            this.checkHeader(name);
        }

        @Override
        public void addIntHeader(String name, int value) {
            super.addIntHeader(name, value);
            this.checkHeader(name);
        }

        private void checkHeader(String name) {
            if ("content-length".equalsIgnoreCase(name)) {
                this.didSetContentLength = true;
            }
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            this.originalOutputStream = this.getResponse().getOutputStream();
            return this.noBodyOutputStream;
        }

        @Override
        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.noBodyWriter == null) {
                this.noBodyWriter = new NoBodyPrintWriter(this.noBodyOutputStream, this.getCharacterEncoding());
            }
            return this.noBodyWriter;
        }

        @Override
        public void reset() {
            super.reset();
            this.resetBuffer();
            this.originalOutputStream = null;
        }

        @Override
        public void resetBuffer() {
            this.noBodyOutputStream.resetBuffer();
            if (this.noBodyWriter != null) {
                this.noBodyWriter.resetBuffer();
            }
        }
    }

    private static class TomcatHack {
        private static final Class<?> REQUEST_FACADE_CLAZZ;
        private static final Method GET_ALLOW_TRACE;

        private TomcatHack() {
        }

        public static boolean getAllowTrace(HttpServletRequest req) {
            if (REQUEST_FACADE_CLAZZ != null && GET_ALLOW_TRACE != null && REQUEST_FACADE_CLAZZ.isAssignableFrom(req.getClass())) {
                try {
                    return (Boolean)GET_ALLOW_TRACE.invoke((Object)req, (Object[])null);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return true;
        }

        static {
            Method m1 = null;
            Class<?> c1 = null;
            try {
                c1 = Class.forName("org.apache.catalina.connector.RequestFacade");
                m1 = c1.getMethod("getAllowTrace", null);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
            REQUEST_FACADE_CLAZZ = c1;
            GET_ALLOW_TRACE = m1;
        }
    }
}

